////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  OBPDFView.h
//    View component in MVC for PDF generation support.
//
//  Copyright (C) 2010 MYOB US, Inc., all rights reserved.
//
//  Change History (most recent first):
//
//	09/16/10  K.L.S.  Created file.
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#import <Cocoa/Cocoa.h>

@class OBPDFViewModel;

@interface OBPDFView : NSView
{
@private
	NSUInteger currentPage;
	OBPDFViewModel* pdfViewModel;
	float scalingFactor;
	BOOL scalingDisabled;
	BOOL isClippingSet;
}

-(void)setModel:(OBPDFViewModel*)newViewModel;
@property (nonatomic) float scalingFactor;
@property (nonatomic) BOOL scalingDisabled;
-(void)setClipRect:(NSRect)clipRect;

@end
